﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP.EFR.DAL;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Custom.EFR.Admin
{
    public partial class AdminEditReferenceRange : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                Label lb = (Label)FormViewReferenceRange.FindControl("LabelAnalyteName");
                if (lb != null)
                {
                    ReplacePageTitle("Administration > Reference Ranges > " + lb.Text);
                }
                else
                {
                    ReplacePageTitle("Administration > Reference Ranges");
                }             
            }
        }

        protected void UpdateCancelButton_Click(object sender, EventArgs e)
        {
            Response.Redirect("AdminListReferenceRanges.aspx");
        }
        protected void ObjectDataSourceReferenceRange_Updated(object sender, ObjectDataSourceStatusEventArgs e)
        {
            Response.Redirect("AdminListReferenceRanges.aspx");
        }

        protected void ObjectDataSourceUnit_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}